﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace CashierCrisis.Behaviors
{
    [DefaultProperty("Seconds")]
    public class Wait : Behavior
    {
   

        [Category("Settings"),Description("How long this behavior will wait.")]
        public int Miliseconds { get; set; }
        private int elapsed;

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            elapsed += gameTime.ElapsedGameTime.Milliseconds;

            if (elapsed >= Miliseconds)
            {
                return Completed;
            }

            return Running;
        }

    }
}
